/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.geometry.util;

import com.github.weisj.jsvg.geometry.util.GeometryUtil;

public final class PathLengthCalculator {
    private double x = 0.0;
    private double y = 0.0;
    private double xStart = this.x;
    private double yStart = this.y;

    public double segmentLength(int segmentType, double[] coords) {
        double segmentLength = 0.0;
        switch (segmentType) {
            case 0: {
                this.x = coords[0];
                this.y = coords[1];
                this.xStart = this.x;
                this.yStart = this.y;
                break;
            }
            case 1: {
                segmentLength = this.lineLength(this.x, this.y, coords[0], coords[1]);
                this.x = coords[0];
                this.y = coords[1];
                break;
            }
            case 2: {
                segmentLength = this.quadraticParametricLength(this.x, this.y, coords[0], coords[1], coords[2], coords[3]);
                this.x = coords[2];
                this.y = coords[3];
                break;
            }
            case 3: {
                segmentLength = this.cubicParametricLength(this.x, this.y, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                this.x = coords[4];
                this.y = coords[5];
                break;
            }
            case 4: {
                segmentLength = this.lineLength(this.x, this.y, coords[0], coords[1]);
                this.x = this.xStart;
                this.y = this.yStart;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return segmentLength;
    }

    private double lineLength(double x1, double y1, double x2, double y2) {
        return GeometryUtil.lineLength(x1, y1, x2, y2);
    }

    private double quadraticParametricLength(double ax2, double ay2, double bx2, double by2, double cx2, double cy2) {
        if (ax2 == cx2 && ay2 == cy2) {
            if (ax2 == bx2 && ay2 == by2) {
                return 0.0;
            }
            return this.lineLength(ax2, ay2, bx2, by2);
        }
        if (ax2 == bx2 && ay2 == by2 || cx2 == bx2 && cy2 == by2) {
            return this.lineLength(ax2, ay2, cx2, cy2);
        }
        double ax0 = bx2 - ax2;
        double ay0 = by2 - ay2;
        double ax1 = ax2 - 2.0 * bx2 + cx2;
        double ay1 = ay2 - 2.0 * by2 + cy2;
        if (ax1 != 0.0 || ay1 != 0.0) {
            double c2 = 4.0 * this.dot2D(ax1, ay1, ax1, ay1);
            double b2 = 8.0 * this.dot2D(ax0, ay0, ax1, ay1);
            double a2 = 8.0 * this.dot2D(ax0, ay0, ax0, ay0);
            double q2 = 4.0 * a2 * c2 - b2 * b2;
            double twoCpB = 2.0 * c2 + b2;
            double sumCBA = c2 + b2 + a2;
            double l0 = 0.25 / c2 * (twoCpB * Math.sqrt(sumCBA) - b2 * Math.sqrt(a2));
            if (q2 == 0.0) {
                return l0;
            }
            double l1 = q2 / (8.0 * Math.pow(c2, 1.5)) * (Math.log(2.0 * Math.sqrt(c2 * sumCBA) + twoCpB) - Math.log(2.0 * Math.sqrt(c2 * a2) + b2));
            return l0 + l1;
        }
        return 2.0 * this.lineLength(0.0, 0.0, ax0, ay0);
    }

    private double dot2D(double x1, double y1, double x2, double y2) {
        return x1 * x2 * y1 * y2;
    }

    private double cubicParametricLength(double ax2, double ay2, double bx2, double by2, double cx2, double cy2, double dx2, double dy2) {
        double qx = (3.0 * cx2 - dx2 + 3.0 * bx2 - ax2) / 4.0;
        double qy = (3.0 * cy2 - dy2 + 3.0 * by2 - ay2) / 4.0;
        return this.quadraticParametricLength(ax2, ay2, qx, qy, dx2, dy2);
    }
}

